<?php

namespace VM\ApiBundle\Entity;

use FOS\UserBundle\Model\User as BaseUser;
use Doctrine\ORM\Mapping as ORM;

/**
 * User
 *
 * @ORM\Table(name="users",indexes={@ORM\Index(name="password_recovery_idx", columns={"password_recovery_token"})})
 * @ORM\Entity
 */
class User extends BaseUser
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=70)
     */
    private $name = '';

    /**
     * @var string
     *
     * @ORM\Column(name="surname", type="string", length=100)
     */
    private $surname = '';

    /**
     * @var string
     *
     * @ORM\Column(name="max_allowed_tokens", type="integer")
     */
    private $maxAllowedTokens = 3;

    /**
     * @var string $external_id
     *
     * @ORM\Column(name="external_id", type="string", length=50, nullable=true)
     */
    private $external_id;

    /**
     * Password recovery token
     *
     * @var string
     * @ORM\Column(name="password_recovery_token", type="string", length=255, nullable=true)
     */
    protected $passwordRecoveryToken;
    

    /**
     * @ORM\OneToMany(targetEntity="UserToken", mappedBy="user", cascade={"remove"})
     * @ORM\OrderBy({"expireAt" = "ASC"})
     */
    protected $tokens;


    /**
     * @ORM\ManyToMany(targetEntity="ApplicationRole", mappedBy="users")
     * @ORM\JoinTable(name="user_application_roles")
     */
    protected $appRoles;


    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set email
     *
     * @param string $email
     * @return User
     */
    public function setEmail($email)
    {
        $this->email = $email;
    
        return $this;
    }

    /**
     * Get email
     *
     * @return string 
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return User
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set surname
     *
     * @param string $surname
     * @return User
     */
    public function setSurname($surname)
    {
        $this->surname = $surname;
    
        return $this;
    }

    /**
     * Get surname
     *
     * @return string 
     */
    public function getSurname()
    {
        return $this->surname;
    }

    /**
     * Set maxAllowedTokens
     *
     * @param integer $maxAllowedTokens
     * @return User
     */
    public function setMaxAllowedTokens($maxAllowedTokens)
    {
        $this->maxAllowedTokens = $maxAllowedTokens;
    
        return $this;
    }

    /**
     * Get maxAllowedTokens
     *
     * @return integer 
     */
    public function getMaxAllowedTokens()
    {
        return $this->maxAllowedTokens;
    }

    /**
     * Add tokens
     *
     * @param \VM\ApiBundle\Entity\UserToken $tokens
     * @return User
     */
    public function addToken(\VM\ApiBundle\Entity\UserToken $tokens)
    {
        $this->tokens[] = $tokens;
    
        return $this;
    }

    /**
     * Remove tokens
     *
     * @param \VM\ApiBundle\Entity\UserToken $tokens
     */
    public function removeToken(\VM\ApiBundle\Entity\UserToken $tokens)
    {
        $this->tokens->removeElement($tokens);
    }

    /**
     * Get tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->tokens;
    }

    /**
     * Set passwordRecoveryToken
     *
     * @param string $passwordRecoveryToken
     * @return User
     */
    public function setPasswordRecoveryToken($passwordRecoveryToken)
    {
        $this->passwordRecoveryToken = $passwordRecoveryToken;
    
        return $this;
    }

    /**
     * Get passwordRecoveryToken
     *
     * @return string 
     */
    public function getPasswordRecoveryToken()
    {
        return $this->passwordRecoveryToken;
    }

    /**
     * Add appRoles
     *
     * @param \VM\ApiBundle\Entity\ApplicationRole $appRoles
     * @return User
     */
    public function addAppRole(\VM\ApiBundle\Entity\ApplicationRole $appRoles)
    {
        $this->appRoles[] = $appRoles;
    
        return $this;
    }

    /**
     * Remove appRoles
     *
     * @param \VM\ApiBundle\Entity\ApplicationRole $appRoles
     */
    public function removeAppRole(\VM\ApiBundle\Entity\ApplicationRole $appRoles)
    {
        $this->appRoles->removeElement($appRoles);
    }

    /**
     * Get appRoles
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAppRoles()
    {
        return $this->appRoles;
    }


    public function setSalt($salt)
    {
        $this->salt = $salt;
    }

    /**
     * Set external_id
     *
     * @param string $externalId
     * @return User
     */
    public function setExternalId($externalId)
    {
        $this->external_id = $externalId;
    
        return $this;
    }

    /**
     * Get external_id
     *
     * @return string 
     */
    public function getExternalId()
    {
        return $this->external_id;
    }
}